import { StyleSheet } from "react-native";
import dpr from "../../../../../screens/Utilities/CustomStyleAttribute/dpr";

export default styles = StyleSheet.create({
    container: {
        width: "100%",
        backgroundColor: "#F3F3F3",
        borderRadius: 6,
        paddingTop: dpr(15),
        paddingHorizontal: dpr(15),
    },
    chatNow: {
        backgroundColor: "#FFFFFF",
        flexDirection: "row",
        padding: dpr(15),
        justifyContent: "space-between",
        width: "100%",
    },
    chatNowDesc: {
        width: '50%',
    },
    chatNowTitle: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(13),
    },
    chatNowSubtitle: {
        marginTop: 2,
        fontFamily: "DMSans_700Bold",
        fontSize: dpr(16),
    },
    chatNowButton: {
        marginLeft: dpr(16),
        flexDirection: "row",
        alignItems: "center",
        backgroundColor: "#FCCA19",
        paddingVertical: dpr(9),
        paddingHorizontal: dpr(25),
        borderRadius: 2,
        width: '45%'
    },
    chatNowButtonText: {
        marginRight: dpr(9),
        fontFamily: "DMSans_700Bold",
        fontSize: dpr(14),
    },
    description: {
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(14),
        paddingTop: dpr(15),
        color: "#898989",
        lineHeight: 23,
    },
    support: {
        paddingVertical: dpr(20),
    },
    supportItem: {
        flexDirection: "row",
        alignItems: "center",
    },
    supportText: {
        marginLeft: dpr(12),
        marginVertical: dpr(8),
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(14),
        color: "#2C2C2C",
        lineHeight: 14.06,
    },
    profileCard: {
        flexWrap: "wrap",
        flexDirection: "row",
        justifyContent: "space-between",
    },
    profileCardItem: {
        backgroundColor: "#FFFFFF",
        paddingHorizontal: dpr(10),
        paddingVertical: dpr(10),
        marginBottom: dpr(15),
        borderRadius: 4,
        textAlign: "center",
        width: (dpr("wf") / 3) * 1.2,
        height: (dpr("wf") / 4.5) * 1.4,
        flexDirection: "column",
        justifyContent: "space-between",
    },
    profileCardItemBg: (id) => ({
        backgroundColor: id === 0 ? "#2C2C2C" : "#FFFFFF" 
    }),
    profileCardItemText: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(16),
        lineHeight: 21,
        color: "#2C2C2C",
        flexWrap: "wrap",
    },
    profileCardItemTextColor: (id) => ({
        color: id === 0 ? "#FFFFFF" : "#2C2C2C"
    }),
    profileCardItemCount: {
        marginTop: dpr(9),
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(28),
        color: "#33C172",
        lineHeight: 33,
    },
    profileCardItemCountColor: (id) => ({
        color: id === 0 ? "#FFFFFF" : "#33C172"
    }),
    percentage: {
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(16),
        color: "#33C172",
    },
});
